create or replace package body tbicds.PCK_MILITARY is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*Get military service recordset*/
   procedure GetMilitaryServiceRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
   
      --open recordset
      v_vSql := 'select * from tbicds.stat_military_service where active = 1';
      open rs for v_vSql;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_MILITARY.GetMilitaryServiceRS(): ' || sqlErrm;
   end;

   /*Get military duty station recordset*/
   procedure GetMilitaryDutyStationRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2,
                                     rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_bMAJCOMRights boolean := false;
      v_bHQRights     boolean := false;
      v_nDIMS_ID      number := 0;
      v_nMAJCOM_ID    number := 0;
   begin
      po_nStatusCode    := 0;
      po_vStatusComment := '';
   
      -- get base id
      begin
         v_vSql := 'select dims_id from tbicds.app_user where fx_user_id = :P0';
         execute immediate v_vSql into v_nDIMS_ID using pi_nUserID;
      exception
         when others then
            null;
      end;
   
      --open recordset
      v_vSql := 'select distinct t.* '
                || 'from tbicds.stat_dims_base t '
                || 'where t.active = 1 '
                || 'order by t.sort_order';
      open rs for v_vSQL;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_MILITARY.GetMilitaryDutyStationRS(): ' || sqlErrm;
   end;

end;
/

